<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        $modules = [
            'profile' => ['view', 'update', 'delete'],

            'room' => ['view', 'create', 'update', 'delete'],
            'tag' => ['view', 'create', 'update', 'delete'],
            'category' => ['view', 'create', 'update', 'delete'],
            'subcategory' => ['view', 'create', 'update', 'delete', 'status'],

            'product' => [
                'view',
                'create',
                'update',
                'delete',
                'stock',
                'image'
            ],

            'banner' => ['view', 'create', 'update', 'delete', 'status'],

            'coupon' => ['view', 'create', 'update', 'delete', 'status'],

            'stock' => ['view', 'update'],
            'location' => ['view', 'create', 'update', 'delete'],
        ];

        $permissions = [];

        foreach ($modules as $module => $actions) {
            foreach ($actions as $action) {
                $permissions[] = Permission::firstOrCreate([
                    'name' => "$module.$action",
                    'guard_name' => 'web',
                ]);
            }
        }

        // 🔑 ROLES
        $admin = Role::firstOrCreate(['name' => 'Admin']);
        $masterFranchise = Role::firstOrCreate(['name' => 'Master Franchise Owner']);
        $franchise = Role::firstOrCreate(['name' => 'Franchise Owner']);

        // ✅ Admin gets everything
        $admin->syncPermissions(Permission::all());

        // ✅ Master Franchise (mostly read + reports)
        $masterFranchise->syncPermissions([
            'product.view',
            'category.view',
            'subcategory.view',
            'subcategory.view',
            'banner.view',
            'coupon.view',
            'stock.view',
            'location.view',
        ]);

        // ✅ Franchise Owner (limited control)
        $franchise->syncPermissions([
            'product.view',
            'product.create',
            'product.update',

            'stock.view',
            'stock.update',

            'coupon.view',
        ]);
    }
}
